// 作者关注控制器
package com.ruoyi.web.controller.system;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.SysUserFollow;
import com.ruoyi.system.service.ISysUserFollowService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/system/user/follow")
public class SysUserFollowController extends BaseController {
    @Autowired
    private ISysUserFollowService followService;

    @PreAuthorize("@ss.hasPermi('system:user:follow:add')")
    @PostMapping
    public AjaxResult follow(@RequestBody SysUserFollow follow) {
        follow.setUserId(getUserId());
        return toAjax(followService.followAuthor(follow));
    }

    @PreAuthorize("@ss.hasPermi('system:user:follow:remove')")
    @DeleteMapping
    public AjaxResult unfollow(@RequestBody SysUserFollow follow) {
        follow.setUserId(getUserId());
        return toAjax(followService.unfollowAuthor(follow));
    }

    @GetMapping("/list")
    public AjaxResult list() {
        return AjaxResult.success(followService.getFollowList(getUserId()));
    }

    @GetMapping("/isFollowing/{authorId}")
    public AjaxResult isFollowing(@PathVariable Long authorId) {
        SysUserFollow follow = new SysUserFollow();
        follow.setUserId(getUserId());
        follow.setAuthorId(authorId);
        return AjaxResult.success(followService.isFollowing(follow));
    }
}