import pymysql
import bcrypt
import config  # 使用你已有的 config.get_db_connection()

def insert_test_user():
    email = '22301110@bjtu.edu.cn'
    password = '123456'
    hashed_pwd = bcrypt.hashpw(password.encode(), bcrypt.gensalt()).decode()

    try:
        conn = config.get_db_connection()
        cursor = conn.cursor()

        cursor.execute("""
            INSERT INTO sys_user (
                user_name, nick_name, password, email, create_time, del_flag, status, user_type
            ) VALUES (%s, %s, %s, %s, NOW(), '0', '0', '00')
        """, (email, email, hashed_pwd, email))

        conn.commit()
        print("✅ 用户插入成功")
    except Exception as e:
        print("❌ 插入失败:", e)
    finally:
        cursor.close()
        conn.close()


def delete_test_user():
    email = '22301110@bjtu.edu.cn'

    try:
        conn = config.get_db_connection()
        cursor = conn.cursor()

        cursor.execute("DELETE FROM sys_user WHERE email = %s", (email,))
        conn.commit()
        print("🗑️ 用户删除成功")
    except Exception as e:
        print("❌ 删除失败:", e)
    finally:
        cursor.close()
        conn.close()


if __name__ == '__main__':
    # 测试：插入
    #insert_test_user()

    # 测试：删除
    delete_test_user()
