package com.ruoyi.reward.domain;

import java.math.BigDecimal;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 悬赏任务对象 reward_tasks
 *
 * @author ruoyi
 * @date 2025-05-17
 */
public class RewardTasks extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 悬赏任务ID */
    private Long rewardId;

    /** 任务标题 */
    @Excel(name = "任务标题")
    private String title;

    /** 任务描述 */
    @Excel(name = "任务描述")
    private String description;

    /** 奖励金额 */
    @Excel(name = "奖励金额")
    private BigDecimal amount;

    /** 任务状态 (0开放 1已接受 2已完成) */
    @Excel(name = "任务状态", readConverterExp = "0=开放,1=已接受,2=已完成")
    private String status;

    /** 发布者ID */
    @Excel(name = "发布者ID")
    private Long publisherId;

    /** 接受者ID */
    @Excel(name = "接受者ID")
    private Long accepterId;

    public void setRewardId(Long rewardId)
    {
        this.rewardId = rewardId;
    }

    public Long getRewardId()
    {
        return rewardId;
    }

    public void setTitle(String title)
    {
        this.title = title;
    }

    public String getTitle()
    {
        return title;
    }

    public void setDescription(String description)
    {
        this.description = description;
    }

    public String getDescription()
    {
        return description;
    }

    public void setAmount(BigDecimal amount)
    {
        this.amount = amount;
    }

    public BigDecimal getAmount()
    {
        return amount;
    }

    public void setStatus(String status)
    {
        this.status = status;
    }

    public String getStatus()
    {
        return status;
    }

    public void setPublisherId(Long publisherId)
    {
        this.publisherId = publisherId;
    }

    public Long getPublisherId()
    {
        return publisherId;
    }

    public void setAccepterId(Long accepterId)
    {
        this.accepterId = accepterId;
    }

    public Long getAccepterId()
    {
        return accepterId;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("rewardId", getRewardId())
                .append("title", getTitle())
                .append("description", getDescription())
                .append("amount", getAmount())
                .append("status", getStatus())
                .append("publisherId", getPublisherId())
                .append("accepterId", getAccepterId())
                .append("createTime", getCreateTime())
                .append("updateTime", getUpdateTime())
                .append("remark", getRemark())
                .toString();
    }
}