package com.ruoyi.reward.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.reward.mapper.RewardTasksMapper;
import com.ruoyi.reward.domain.RewardTasks;
import com.ruoyi.reward.service.IRewardTasksService;

/**
 * 悬赏任务Service业务层处理
 *
 * @author ruoyi
 * @date 2025-05-17
 */
@Service
public class RewardTasksServiceImpl implements IRewardTasksService
{
    @Autowired
    private RewardTasksMapper rewardTasksMapper;

    /**
     * 查询悬赏任务
     *
     * @param rewardId 悬赏任务主键
     * @return 悬赏任务
     */
    @Override
    public RewardTasks selectRewardTasksByRewardId(Long rewardId)
    {
        return rewardTasksMapper.selectRewardTasksByRewardId(rewardId);
    }

    /**
     * 查询悬赏任务列表
     *
     * @param rewardTasks 悬赏任务
     * @return 悬赏任务
     */
    @Override
    public List<RewardTasks> selectRewardTasksList(RewardTasks rewardTasks)
    {
        return rewardTasksMapper.selectRewardTasksList(rewardTasks);
    }

    /**
     * 新增悬赏任务
     *
     * @param rewardTasks 悬赏任务
     * @return 结果
     */
    @Override
    @Transactional
    public int insertRewardTasks(RewardTasks rewardTasks)
    {
        rewardTasks.setCreateTime(DateUtils.getNowDate());
        return rewardTasksMapper.insertRewardTasks(rewardTasks);
    }

    /**
     * 修改悬赏任务
     *
     * @param rewardTasks 悬赏任务
     * @return 结果
     */
    @Override
    @Transactional
    public int updateRewardTasks(RewardTasks rewardTasks)
    {
        rewardTasks.setUpdateTime(DateUtils.getNowDate());
        return rewardTasksMapper.updateRewardTasks(rewardTasks);
    }

    /**
     * 批量删除悬赏任务
     *
     * @param rewardIds 需要删除的悬赏任务主键
     * @return 结果
     */
    @Override
    @Transactional
    public int deleteRewardTasksByRewardIds(Long[] rewardIds)
    {
        return rewardTasksMapper.deleteRewardTasksByRewardIds(rewardIds);
    }

    /**
     * 删除悬赏任务信息
     *
     * @param rewardId 悬赏任务主键
     * @return 结果
     */
    @Override
    @Transactional
    public int deleteRewardTasksByRewardId(Long rewardId)
    {
        return rewardTasksMapper.deleteRewardTasksByRewardId(rewardId);
    }

    /**
     * 根据悬赏ID查询悬赏BT
     *
     * @param rewardId 悬赏任务ID
     * @return 悬赏BT的torrent_id
     */
    @Override
    public Integer selectRewardBtByRewardId(Integer rewardId)
    {
        return rewardTasksMapper.selectRewardBtByRewardId(rewardId);
    }

    /**
     * 新增悬赏BT
     *
     * @param rewardId 悬赏任务ID
     * @param rewardBt Torrent ID
     * @return 结果
     */
    @Override
    @Transactional
    public int insertRewardBt(Integer rewardId, Integer rewardBt)
    {
        return rewardTasksMapper.insertRewardBt(rewardId, rewardBt);
    }
}