package com.ruoyi.torrent.mapper;

import java.util.List;
import com.ruoyi.torrent.domain.BtTorrent;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

/**
 * 种子主Mapper接口
 * 
 * @author ruoyi
 * @date 2025-04-21
 */
@Mapper
public interface BtTorrentMapper 
{
    /**
     * 查询种子主
     * 
     * @param torrentId 种子主主键
     * @return 种子主
     */
    public BtTorrent selectBtTorrentByTorrentId(Long torrentId);

    /**
     * 查询种子主列表
     * 
     * @param btTorrent 种子主
     * @return 种子主集合
     */
    public List<BtTorrent> selectBtTorrentList(BtTorrent btTorrent);

    /**
     * 新增种子主
     * 
     * @param btTorrent 种子主
     * @return 结果
     */
    public int insertBtTorrent(BtTorrent btTorrent);

    /**
     * 修改种子主
     * 
     * @param btTorrent 种子主
     * @return 结果
     */
    public int updateBtTorrent(BtTorrent btTorrent);

    /**
     * 删除种子主
     * 
     * @param torrentId 种子主主键
     * @return 结果
     */
    public int deleteBtTorrentByTorrentId(Long torrentId);

    /**
     * 批量删除种子主
     * 
     * @param torrentIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteBtTorrentByTorrentIds(Long[] torrentIds);

    /**
     * 根据ID列表查询种子信息（保持顺序）
     *
     * @param ids 种子ID列表
     * @return 种子列表
     */
    public List<BtTorrent> selectBtTorrentsByIdsOrdered(@Param("list") List<Long> ids);
}
