package com.ruoyi.tracker.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 任务对象 tracker_task
 * 
 * @author ruoyi
 * @date 2025-04-20
 */
public class TrackerTask extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 任务ID */
    private Long taskId;

    /** 所属项目ID */
    @Excel(name = "所属项目ID")
    private Long projectId;

    /** 任务名称 */
    @Excel(name = "任务名称")
    private String taskName;

    /** 任务描述 */
    @Excel(name = "任务描述")
    private String description;

    /** 分配给的用户ID */
    @Excel(name = "分配给的用户ID")
    private Long assignedTo;

    /** 任务状态（open: 待办, in_progress: 进行中, closed: 完成） */
    @Excel(name = "任务状态", readConverterExp = "o=pen:,待=办,,i=n_progress:,进=行中,,c=losed:,完=成")
    private String status;

    /** 任务优先级（low, medium, high） */
    @Excel(name = "任务优先级", readConverterExp = "l=ow,,m=edium,,h=igh")
    private String priority;

    public void setTaskId(Long taskId) 
    {
        this.taskId = taskId;
    }

    public Long getTaskId() 
    {
        return taskId;
    }
    public void setProjectId(Long projectId) 
    {
        this.projectId = projectId;
    }

    public Long getProjectId() 
    {
        return projectId;
    }
    public void setTaskName(String taskName) 
    {
        this.taskName = taskName;
    }

    public String getTaskName() 
    {
        return taskName;
    }
    public void setDescription(String description) 
    {
        this.description = description;
    }

    public String getDescription() 
    {
        return description;
    }
    public void setAssignedTo(Long assignedTo) 
    {
        this.assignedTo = assignedTo;
    }

    public Long getAssignedTo() 
    {
        return assignedTo;
    }
    public void setStatus(String status) 
    {
        this.status = status;
    }

    public String getStatus() 
    {
        return status;
    }
    public void setPriority(String priority) 
    {
        this.priority = priority;
    }

    public String getPriority() 
    {
        return priority;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("taskId", getTaskId())
            .append("projectId", getProjectId())
            .append("taskName", getTaskName())
            .append("description", getDescription())
            .append("assignedTo", getAssignedTo())
            .append("status", getStatus())
            .append("priority", getPriority())
            .append("createTime", getCreateTime())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
