// 种子评论控制器
package com.ruoyi.web.controller.system;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.SysTorrentComment;
import com.ruoyi.system.service.ISysTorrentCommentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/system/torrent/comment")
public class SysTorrentCommentController extends BaseController {
    @Autowired
    private ISysTorrentCommentService commentService;

    @PreAuthorize("@ss.hasPermi('system:torrent:comment:add')")
    @PostMapping
    public AjaxResult add(@RequestBody SysTorrentComment comment) {
        comment.setUserId(getUserId());
        return toAjax(commentService.addComment(comment));
    }

    @GetMapping("/{torrentId}")
    public AjaxResult list(@PathVariable Long torrentId) {
        System.out.println(commentService.getCommentList(torrentId));
        return AjaxResult.success(commentService.getCommentList(torrentId));
    }

    @PreAuthorize("@ss.hasPermi('system:torrent:comment:remove')")
    @DeleteMapping("/{commentId}")
    public AjaxResult remove(@PathVariable Long commentId) {
        return toAjax(commentService.deleteComment(commentId));
    }
}
