package com.ruoyi.web.controller.system;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.SysUserInvite;
import com.ruoyi.system.service.ISysUserInviteService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/system/user/invite")
public class SysUserInviteController extends BaseController {
    @Autowired
    private ISysUserInviteService inviteService;

    @PreAuthorize("@ss.hasPermi('system:user:invite:query')")
    @GetMapping("/code")
    public AjaxResult getInviteCode() {
        SysUserInvite invite = inviteService.getInviteCode(getUserId());
        if (invite == null) {
            return AjaxResult.error("未找到邀请码");
        }
        return AjaxResult.success(invite.getCode());
    }

    @PreAuthorize("@ss.hasPermi('system:user:invite:query')")
    @GetMapping("/user/{code}")
    public AjaxResult getUserByInviteCode(@PathVariable String code) {
        SysUserInvite invite = inviteService.getUserByInviteCode(code);
        if (invite == null) {
            return AjaxResult.error("邀请码不存在");
        }
        return AjaxResult.success(invite.getUserId());
    }
}