//种子评论
package com.ruoyi.system.domain;

import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;

@Data
public class SysTorrentComment extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @Excel(name = "评论ID")
    private Long commentId;

    @Excel(name = "种子ID")
    @NotNull(message = "种子ID不能为空")
    private Long torrentId;

    @Excel(name = "用户ID")
    @NotNull(message = "用户ID不能为空")
    private Long userId;

    @Excel(name = "评论内容")
    @NotBlank(message = "评论内容不能为空")
    private String content;

    @Excel(name = "父评论ID")
    private Long parentId;
}