package com.ruoyi.torrent.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 种子的 Tracker 列对象 bt_torrent_announce
 * 
 * @author ruoyi
 * @date 2025-04-21
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class BtTorrentAnnounce extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 种子ID */
    @Excel(name = "种子ID")
    private Long torrentId;

    /** Tracker announce URL */
    @Excel(name = "Tracker announce URL")
    private String announceUrl;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setTorrentId(Long torrentId) 
    {
        this.torrentId = torrentId;
    }

    public Long getTorrentId() 
    {
        return torrentId;
    }
    public void setAnnounceUrl(String announceUrl) 
    {
        this.announceUrl = announceUrl;
    }

    public String getAnnounceUrl() 
    {
        return announceUrl;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("torrentId", getTorrentId())
            .append("announceUrl", getAnnounceUrl())
            .toString();
    }
}
