package com.ruoyi.torrent.service;

import java.util.List;
import com.ruoyi.torrent.domain.BtTorrentFile;

/**
 * 种子包含的文件列Service接口
 * 
 * @author ruoyi
 * @date 2025-04-21
 */
public interface IBtTorrentFileService 
{
    /**
     * 查询种子包含的文件列
     * 
     * @param id 种子包含的文件列主键
     * @return 种子包含的文件列
     */
    public BtTorrentFile selectBtTorrentFileById(Long id);

    /**
     * 查询种子包含的文件列列表
     * 
     * @param btTorrentFile 种子包含的文件列
     * @return 种子包含的文件列集合
     */
    public List<BtTorrentFile> selectBtTorrentFileList(BtTorrentFile btTorrentFile);

    /**
     * 新增种子包含的文件列
     * 
     * @param btTorrentFile 种子包含的文件列
     * @return 结果
     */
    public int insertBtTorrentFile(BtTorrentFile btTorrentFile);

    /**
     * 修改种子包含的文件列
     * 
     * @param btTorrentFile 种子包含的文件列
     * @return 结果
     */
    public int updateBtTorrentFile(BtTorrentFile btTorrentFile);

    /**
     * 批量删除种子包含的文件列
     * 
     * @param ids 需要删除的种子包含的文件列主键集合
     * @return 结果
     */
    public int deleteBtTorrentFileByIds(Long[] ids);

    /**
     * 删除种子包含的文件列信息
     * 
     * @param id 种子包含的文件列主键
     * @return 结果
     */
    public int deleteBtTorrentFileById(Long id);
}
