package com.ruoyi.torrent.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.torrent.mapper.BtTorrentTagsMapper;
import com.ruoyi.torrent.domain.BtTorrentTags;
import com.ruoyi.torrent.service.IBtTorrentTagsService;

/**
 * 种子标签Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-04-21
 */
@Service
public class BtTorrentTagsServiceImpl implements IBtTorrentTagsService 
{
    @Autowired
    private BtTorrentTagsMapper btTorrentTagsMapper;

    /**
     * 查询种子标签
     * 
     * @param id 种子标签主键
     * @return 种子标签
     */
    @Override
    public BtTorrentTags selectBtTorrentTagsById(Long id)
    {
        return btTorrentTagsMapper.selectBtTorrentTagsById(id);
    }

    /**
     * 查询种子标签列表
     * 
     * @param btTorrentTags 种子标签
     * @return 种子标签
     */
    @Override
    public List<BtTorrentTags> selectBtTorrentTagsList(BtTorrentTags btTorrentTags)
    {
        return btTorrentTagsMapper.selectBtTorrentTagsList(btTorrentTags);
    }

    /**
     * 新增种子标签
     * 
     * @param btTorrentTags 种子标签
     * @return 结果
     */
    @Override
    public int insertBtTorrentTags(BtTorrentTags btTorrentTags)
    {
        return btTorrentTagsMapper.insertBtTorrentTags(btTorrentTags);
    }

    /**
     * 修改种子标签
     * 
     * @param btTorrentTags 种子标签
     * @return 结果
     */
    @Override
    public int updateBtTorrentTags(BtTorrentTags btTorrentTags)
    {
        return btTorrentTagsMapper.updateBtTorrentTags(btTorrentTags);
    }

    /**
     * 批量删除种子标签
     * 
     * @param ids 需要删除的种子标签主键
     * @return 结果
     */
    @Override
    public int deleteBtTorrentTagsByIds(Long[] ids)
    {
        return btTorrentTagsMapper.deleteBtTorrentTagsByIds(ids);
    }

    /**
     * 删除种子标签信息
     * 
     * @param id 种子标签主键
     * @return 结果
     */
    @Override
    public int deleteBtTorrentTagsById(Long id)
    {
        return btTorrentTagsMapper.deleteBtTorrentTagsById(id);
    }
}
