package com.ruoyi.tracker.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 任务日志对象 tracker_task_log
 * 
 * @author ruoyi
 * @date 2025-04-20
 */
public class TrackerTaskLog extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 日志ID */
    private Long logId;

    /** 任务ID */
    @Excel(name = "任务ID")
    private Long taskId;

    /** 操作用户ID */
    @Excel(name = "操作用户ID")
    private Long userId;

    /** 操作类型（创建、更新、删除） */
    @Excel(name = "操作类型", readConverterExp = "创=建、更新、删除")
    private String action;

    /** 操作描述 */
    @Excel(name = "操作描述")
    private String description;

    public void setLogId(Long logId) 
    {
        this.logId = logId;
    }

    public Long getLogId() 
    {
        return logId;
    }
    public void setTaskId(Long taskId) 
    {
        this.taskId = taskId;
    }

    public Long getTaskId() 
    {
        return taskId;
    }
    public void setUserId(Long userId) 
    {
        this.userId = userId;
    }

    public Long getUserId() 
    {
        return userId;
    }
    public void setAction(String action) 
    {
        this.action = action;
    }

    public String getAction() 
    {
        return action;
    }
    public void setDescription(String description) 
    {
        this.description = description;
    }

    public String getDescription() 
    {
        return description;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("logId", getLogId())
            .append("taskId", getTaskId())
            .append("userId", getUserId())
            .append("action", getAction())
            .append("description", getDescription())
            .append("createTime", getCreateTime())
            .toString();
    }
}
