package com.ruoyi.tracker.service;

import java.util.List;
import com.ruoyi.tracker.domain.TrackerTask;

/**
 * 任务Service接口
 * 
 * @author ruoyi
 * @date 2025-04-20
 */
public interface ITrackerTaskService 
{
    /**
     * 查询任务
     * 
     * @param taskId 任务主键
     * @return 任务
     */
    public TrackerTask selectTrackerTaskByTaskId(Long taskId);

    /**
     * 查询任务列表
     * 
     * @param trackerTask 任务
     * @return 任务集合
     */
    public List<TrackerTask> selectTrackerTaskList(TrackerTask trackerTask);

    /**
     * 新增任务
     * 
     * @param trackerTask 任务
     * @return 结果
     */
    public int insertTrackerTask(TrackerTask trackerTask);

    /**
     * 修改任务
     * 
     * @param trackerTask 任务
     * @return 结果
     */
    public int updateTrackerTask(TrackerTask trackerTask);

    /**
     * 批量删除任务
     * 
     * @param taskIds 需要删除的任务主键集合
     * @return 结果
     */
    public int deleteTrackerTaskByTaskIds(Long[] taskIds);

    /**
     * 删除任务信息
     * 
     * @param taskId 任务主键
     * @return 结果
     */
    public int deleteTrackerTaskByTaskId(Long taskId);
}
