package com.ruoyi.announce.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.ruoyi.announce.util.BencodeEncoder;
import com.ruoyi.authentication.domain.SysUserPasskey;
import com.ruoyi.authentication.service.ISysUserPasskeyService;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.announce.service.IAnnounceService;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.utils.SecurityUtils;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.URLCodec;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@RestController
public class AnnounceController extends BaseController {
    // 在你的 Controller 中：

    @Autowired
    private IAnnounceService announceService;

    @Autowired
    private BencodeEncoder bencodeEncoder;






    private byte[] decodeInfoHashAndPeerId(String param) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (int i = 0; i < param.length(); ) {
            char c = param.charAt(i);
            if (c == '%' && i + 2 < param.length()) {
                char hi = param.charAt(i + 1);
                char lo = param.charAt(i + 2);
                if (isHexDigit(hi) && isHexDigit(lo)) {
                    int value = Character.digit(hi, 16) << 4 | Character.digit(lo, 16);
                    bos.write(value);
                    i += 3;
                    continue;
                }
            }
            // 不是合法的 %xx，直接跳过或处理为异常字符
            bos.write((byte) c); // 或者 throw new IllegalArgumentException(...)
            i++;
        }
        return bos.toByteArray();
    }

    private boolean isHexDigit(char c) {
        return (c >= '0' && c <= '9') ||
                (c >= 'A' && c <= 'F') ||
                (c >= 'a' && c <= 'f');
    }




    /**
     * BT Tracker /announce 接口
     * 接收客户端（qBittorrent 等）发来的 announce 请求，返回 bencoded peers 列表
     */

    @GetMapping(value = "/announce", produces = "application/x-bittorrent")
    public void announce(HttpServletRequest request, HttpServletResponse response) throws Exception {
        // —— 打印所有参数 ——
        Map<String, String[]> parameterMap = request.getParameterMap();
        System.out.println("—— 请求参数列表 ——");
        for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
            String paramName = entry.getKey();
            String[] paramValues = entry.getValue();
            System.out.println(paramName + " = " + Arrays.toString(paramValues));
        }


        // —— 4. 获取参数（不使用 @RequestParam） ——
        String infoHashParam = request.getParameter("info_hash");
        String peerIdParam   = request.getParameter("peer_id");
        String portStr       = request.getParameter("port");
        String uploadedStr   = request.getParameter("uploaded");
        String downloadedStr = request.getParameter("downloaded");
        String leftStr       = request.getParameter("left");
        String event         = request.getParameter("event");
        String passkey       = request.getParameter("passkey");
        String ip            = request.getRemoteAddr();

        System.out.println("Received request with parameters:");
        System.out.println("info_hash: " + infoHashParam);
        System.out.println("peer_id: " + peerIdParam);
        System.out.println("port: " + portStr);
        System.out.println("uploaded: " + uploadedStr);
        System.out.println("downloaded: " + downloadedStr);
        System.out.println("left: " + leftStr);
        System.out.println("event: " + event);
        System.out.println("passkey: " + passkey);
        System.out.println("client IP: " + ip);








        if ((infoHashParam == null && peerIdParam == null && portStr == null &&
                uploadedStr == null && downloadedStr == null && leftStr == null)) {

            // 只要 passkey 和 ip 不为空，则认为是 heartbeat
            if (passkey != null && ip != null) {
                // 处理为心跳请求
                Map<String, Object> reply = announceService.handleHeartbeat(ip);
                byte[] bencodeReply = bencodeEncoder.encodeBencode(reply);

                response.setContentType("text/plain");
                response.getOutputStream().write(bencodeReply);
                return;
            }

            // 如果不是心跳，就是错误请求
            response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
            response.setContentType("text/plain");
            response.getWriter().write("Missing required announce parameters.");
            return;
        }

        // —— 5. 转换参数类型 ——
        assert portStr != null;
        int port = Integer.parseInt(portStr);
        long uploaded = Long.parseLong(uploadedStr);
        long downloaded = Long.parseLong(downloadedStr);
        long left = Long.parseLong(leftStr);

        // 确保 URL 解码不会失败，使用更健壮的方法
        assert infoHashParam != null;
        byte[] infoHash = decodeInfoHashAndPeerId(infoHashParam);
        byte[] peerId   = decodeInfoHashAndPeerId(peerIdParam);

        // —— 7. 调用业务逻辑处理 ——
        Map<String, Object> reply = announceService.handleAnnounce(
                infoHash, peerId, port, uploaded, downloaded, left, event, passkey,
                request.getRemoteAddr()
        );

        // —— 8. 返回 Bencode 编码的 tracker 响应 ——
        response.setStatus(HttpServletResponse.SC_OK);
        response.setHeader("Content-Type", "application/x-bittorrent");
        try (var out = response.getOutputStream()) {
            byte[] bencoded = bencodeEncoder.encodeBencode(reply);

            out.write(bencoded);
            out.flush();
        }
    }
    // Scrape 接口
    @GetMapping(value = "/scrape", produces = "application/x-bittorrent")
    public void scrape(@RequestParam("info_hash") String[] infoHashes, HttpServletRequest request, HttpServletResponse response) throws Exception {

        // 收集所有 info_hash 对应的统计数据
        Map<String, Object> scrapeStats = announceService.handleScrape(infoHashes);

        // 将统计数据转换为 Bencode 格式并返回
        byte[] bencodedReply = bencodeEncoder.encodeBencode(scrapeStats);

        response.setStatus(HttpServletResponse.SC_OK);
        response.setHeader("Content-Type", "application/x-bittorrent");
        try (var out = response.getOutputStream()) {
            out.write(bencodedReply);
            out.flush();
        }
    }

    /**
     * 查询当前所有活跃的 Peer 节点
     */
    @GetMapping(value = "/peers", produces = "application/json")
    public TableDataInfo getAllPeers() {
        List<Map<String, Object>> peers = announceService.getAllPeers();
        System.out.println(peers);
        return getDataTable(peers);
    }
}

