package com.ruoyi.tracker.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 项目与用户关联对象 tracker_project_user
 * 
 * @author ruoyi
 * @date 2025-04-20
 */
public class TrackerProjectUser extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 项目ID */
    private Long projectId;

    /** 用户ID */
    private Long userId;

    /** 角色（管理员、成员等） */
    @Excel(name = "角色", readConverterExp = "管=理员、成员等")
    private String role;

    public void setProjectId(Long projectId) 
    {
        this.projectId = projectId;
    }

    public Long getProjectId() 
    {
        return projectId;
    }
    public void setUserId(Long userId) 
    {
        this.userId = userId;
    }

    public Long getUserId() 
    {
        return userId;
    }
    public void setRole(String role) 
    {
        this.role = role;
    }

    public String getRole() 
    {
        return role;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("projectId", getProjectId())
            .append("userId", getUserId())
            .append("role", getRole())
            .append("createTime", getCreateTime())
            .toString();
    }
}
