import subprocess
import time
import requests
import os
import signal
from flask import Flask
from flask_cors import CORS



NGROK_PORT = 6001
NGROK_API = 'http://127.0.0.1:4040/api/tunnels'
NGROK_URL_FILE = 'ngrok_url.txt'

def start_backend():
    print("🚀 启动 Flask 后端...")
    return subprocess.Popen(
        ["venv\\Scripts\\python.exe", "backend.py"],
        creationflags=subprocess.CREATE_NEW_CONSOLE
    )

def start_ngrok():
    print("🌐 启动 Ngrok 隧道（窗口隐藏）...")
    startupinfo = subprocess.STARTUPINFO()
    startupinfo.dwFlags |= subprocess.STARTF_USESHOWWINDOW

    return subprocess.Popen(
        ["ngrok", "http", str(NGROK_PORT)],
        stdout=subprocess.DEVNULL,
        stderr=subprocess.DEVNULL,
        startupinfo=startupinfo
    )


def fetch_ngrok_url(retries=10):
    print("⏳ 正在获取 Ngrok 公网地址...")
    for _ in range(retries):
        try:
            res = requests.get(NGROK_API).json()
            tunnels = res.get("tunnels")
            if tunnels:
                public_url = tunnels[0]["public_url"]
                with open(NGROK_URL_FILE, "w", encoding="utf-8") as f:
                    f.write(public_url)
                print(f"✅ Ngrok 地址: {public_url} 已写入 {NGROK_URL_FILE}")
                return public_url
        except Exception:
            pass
        time.sleep(1)
    print("❌ 获取 Ngrok 地址失败！")
    return None

if __name__ == "__main__":
    backend_proc = start_backend()
    time.sleep(3)  # 等后端稍微先启动

    ngrok_proc = start_ngrok()
    time.sleep(3)  # 等 ngrok 启动

    try:
        fetch_ngrok_url()
        print("\n✅ 所有服务已启动，按 Ctrl+C 退出。")
        while True:
            time.sleep(1)
    except KeyboardInterrupt:
        print("\n🛑 正在关闭服务...")
        backend_proc.terminate()
        ngrok_proc.terminate()
        print("✅ 已关闭")
