package com.ruoyi.system.domain;

import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;

@Data
public class SysUserMessage extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @Excel(name = "消息ID")
    private Long messageId;

    @Excel(name = "发送者ID")
    @NotNull(message = "发送者ID不能为空")
    private Long senderId;

    @Excel(name = "接收者ID")
    @NotNull(message = "接收者ID不能为空")
    private Long receiverId;

    @Excel(name = "消息内容")
    @NotBlank(message = "消息内容不能为空")
    private String content;
}