package com.ruoyi.web.controller.system;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.system.domain.SysUserFollow;
import com.ruoyi.system.service.ISysUserFollowService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/system/user/follow")
public class SysUserFollowController extends BaseController {
    @Autowired
    private ISysUserFollowService followService;

    @PreAuthorize("@ss.hasPermi('system:user:follow:add')")
    @PostMapping
    public AjaxResult follow(@RequestBody SysUserFollow follow) {
        follow.setUserId(getUserId());
        int result = followService.followAuthor(follow);
        if (result == -1) {
            return AjaxResult.error("作者不存在");
        } else if (result == 0) {
            return AjaxResult.error("已关注该作者");
        }
        return toAjax(result);
    }

    @PreAuthorize("@ss.hasPermi('system:user:follow:remove')")
    @DeleteMapping
    public AjaxResult unfollow(@RequestBody SysUserFollow follow) {
        follow.setUserId(getUserId());
        int result = followService.unfollowAuthor(follow);
        if (result == -1) {
            return AjaxResult.error("作者不存在");
        }
        return toAjax(result);
    }

    @GetMapping("/list")
    public AjaxResult list() {
        return AjaxResult.success(followService.getFollowList(getUserId()));
    }

    @PreAuthorize("@ss.hasPermi('system:user:follow:query')")
    @GetMapping("/isFollowing/{authorUsername}")
    public AjaxResult isFollowing(@PathVariable String authorUsername) {
        SysUserFollow follow = new SysUserFollow();
        follow.setUserId(getUserId());
        follow.setAuthorUsername(authorUsername);
        return AjaxResult.success(followService.isFollowing(follow));
    }
}