package com.ruoyi.system.domain;

import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;
import jakarta.validation.constraints.NotNull;

@Data
public class SysUserFollow extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @Excel(name = "关注ID")
    private Long followId;

    @Excel(name = "用户ID")
    @NotNull(message = "用户ID不能为空")
    private Long userId;

    @Excel(name = "作者ID")
    @NotNull(message = "作者ID不能为空")
    private Long authorId;

    // 用于接收前端传入的作者用户名
    private String authorUsername;
}