// 作者关注服务实现
package com.ruoyi.system.service.impl;

import com.ruoyi.system.domain.SysUserFollow;
import com.ruoyi.system.mapper.SysUserFollowMapper;
import com.ruoyi.system.service.ISysUserFollowService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.List;

@Service
public class SysUserFollowServiceImpl implements ISysUserFollowService {
    @Autowired
    private SysUserFollowMapper followMapper;

    @Override
    public int followAuthor(SysUserFollow follow) {
        if (followMapper.selectFollow(follow) != null) {
            return 0; // 已经关注
        }
        return followMapper.insertFollow(follow);
    }

    @Override
    public int unfollowAuthor(SysUserFollow follow) {
        return followMapper.deleteFollow(follow);
    }

    @Override
    public List<SysUserFollow> getFollowList(Long userId) {
        return followMapper.selectFollowListByUserId(userId);
    }

    @Override
    public boolean isFollowing(SysUserFollow follow) {
        return followMapper.selectFollow(follow) != null;
    }
}