package com.ruoyi.system.service.impl;

import com.ruoyi.system.domain.SysUserMessage;
import com.ruoyi.system.mapper.SysUserMessageMapper;
import com.ruoyi.system.service.ISysUserMessageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.List;

@Service
public class SysUserMessageServiceImpl implements ISysUserMessageService {
    @Autowired
    private SysUserMessageMapper messageMapper;

    @Override
    public int sendMessage(SysUserMessage message) {
        return messageMapper.insertMessage(message);
    }

    @Override
    public List<SysUserMessage> getMessageList(Long userId1, Long userId2) {
        return messageMapper.selectMessageListByUserIds(userId1, userId2);
    }
}