package com.example.g8backend.controller;

import com.example.g8backend.entity.Message;
import com.example.g8backend.entity.User;
import com.example.g8backend.service.IUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/user")
public class UserController {

    @Autowired
    private IUserService userService;

    // 获取已登录的用户信息
    @GetMapping
    public ResponseEntity<?> getUserInfo(){
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        long userId = (long) authentication.getPrincipal();
        User user = userService.getById(userId);
        user.setPassword(null);
        return ResponseEntity.ok(user);
    }
    // ==================== 关注功能 ====================
    @PostMapping("/follow/{userId}")
    public ResponseEntity<?> followUser(@PathVariable Long userId) {
        Long currentUserId = getCurrentUserId();
        boolean success = userService.followUser(currentUserId, userId);
        return ResponseEntity.ok(Map.of("success", success));
    }

    @DeleteMapping("/follow/{userId}")
    public ResponseEntity<?> unfollowUser(@PathVariable Long userId) {
        Long currentUserId = getCurrentUserId();
        boolean success = userService.unfollowUser(currentUserId, userId);
        return ResponseEntity.ok(Map.of("success", success));
    }

    @GetMapping("/followings")
    public ResponseEntity<?> getFollowings() {
        Long currentUserId = getCurrentUserId();
        List<User> followings = userService.getFollowings(currentUserId);
        return ResponseEntity.ok(followings);
    }

    @GetMapping("/followers")
    public ResponseEntity<?> getFollowers() {
        Long currentUserId = getCurrentUserId();
        List<User> followers = userService.getFollowers(currentUserId);
        return ResponseEntity.ok(followers);
    }

    // ==================== 私信功能 ====================
    @PostMapping("/message/{receiverId}")
    public ResponseEntity<?> sendMessage(
            @PathVariable Long receiverId,
            @RequestBody String content
    ) {
        Long senderId = getCurrentUserId();
        Long messageId = userService.sendMessage(senderId, receiverId, content);
        return ResponseEntity.ok(Map.of("messageId", messageId));
    }

    @GetMapping("/messages/{otherUserId}")
    public ResponseEntity<?> getMessages(@PathVariable Long otherUserId) {
        Long currentUserId = getCurrentUserId();
        List<Message> messages = userService.getMessages(currentUserId, otherUserId);
        return ResponseEntity.ok(messages);
    }

    @GetMapping("/messages/history")
    public ResponseEntity<?> getMessageHistory() {
        Long currentUserId = getCurrentUserId();
        List<Message> messages = userService.getMessageHistory(currentUserId);
        return ResponseEntity.ok(messages);
    }

    // ==================== 工具方法 ====================
    private Long getCurrentUserId() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return (Long) authentication.getPrincipal();
    }
}
