package com.example.g8backend.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.example.g8backend.entity.PostView;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

@Mapper
public interface PostViewMapper extends BaseMapper<PostView> {


    @Select("SELECT post_id FROM post_views WHERE user_id = #{userId}")
    List<Long> findViewedPostIds(@Param("userId") Long userId);


    @Select("SELECT * FROM post_views WHERE user_id = #{userId} ORDER BY view_time DESC LIMIT #{limit}")
    List<PostView> selectRecentViews(@Param("userId") Long userId, @Param("limit") int limit);
}