package com.example.g8backend.controller;

import com.example.g8backend.dto.ApiResponse;
import com.example.g8backend.entity.Report;
import com.example.g8backend.service.AdminService;
import com.example.g8backend.service.IReportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/admin")
public class AdminController {
    @Autowired
    private AdminService adminService;
    private IReportService reportService;
    @PostMapping("/grant-vip/{userId}")
    @PreAuthorize("hasRole('ADMIN')") // 仅允许管理员访问
    public String grantVip(@PathVariable Long userId) {
        boolean success = adminService.grantVip(userId);
        return success ? "VIP授予成功" : "操作失败（用户不存在）";
    }
    // 获取举报记录（支持按状态过滤）
    @GetMapping("/reports")
    @PreAuthorize("hasRole('ADMIN')")
    public ApiResponse<List<Report>> getReports(
            @RequestParam(required = false) String status) {
        Long adminId = (Long) SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        return ApiResponse.success(reportService.getReports(status, adminId));
    }
    // 处理举报
    @PutMapping("/reports/{reportId}")
    @PreAuthorize("hasRole('ADMIN')")
    public ApiResponse<String> resolveReport(
            @PathVariable Long reportId,
            @RequestParam String status,
            @RequestParam(required = false) String notes) {
        Long adminId = (Long) SecurityContextHolder.getContext().getAuthentication().getPrincipal();//这里之前不太对，service改了
        reportService.resolveReport(reportId, adminId, status, notes);
        return ApiResponse.success("举报处理完成");
    }

}