package com.example.g8backend.controller;

import com.example.g8backend.entity.Comment;
import com.example.g8backend.service.ICommentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/comments")
public class CommentController {

    @Autowired
    private ICommentService commentService;

    // 创建评论
    @PostMapping
    public void createComment(@RequestParam Long postId, @RequestParam Long userId,
                              @RequestParam String content, @RequestParam(required = false) Long parentCommentId) {
        commentService.createComment(postId, userId, content, parentCommentId);
    }

    // 获取某帖子下的所有评论，包括顶级评论及其子评论
    @GetMapping("/post/{postId}")
    public List<Comment> getCommentsByPostId(@PathVariable Long postId) {
        return commentService.getCommentsByPostId(postId);
    }

    // 删除评论
    @DeleteMapping("/{commentId}")
    public void deleteComment(@PathVariable Long commentId) {
        commentService.deleteComment(commentId);
    }
}
