package com.example.g8backend.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.sql.Timestamp;
import lombok.Data;
import lombok.experimental.Accessors;

@Data
@TableName("posts")
@Accessors(chain = true)
public class Post {
    @TableId(type = IdType.AUTO)
    private Long postId;

    private Long userId;
    private String postTitle;
    private String postContent;
    private Timestamp createdAt;
    private String postType;

    @TableField("view_count")
    private Integer viewCount = 0;

    // 新增热度评分字段
    @TableField("hot_score")
    private Double hotScore = 5.0; // 初始热度

    // 新增最后计算时间字段
    @TableField("last_calculated")
    private Timestamp lastCalculated;

    @Override
    public String toString() {
        return "Post{" +
                "postId=" + postId +
                ", userId=" + userId +
                ", postTitle='" + postTitle + '\'' +
                ", postContent='" + postContent + '\'' +
                ", createdAt=" + createdAt +
                ", postType='" + postType + '\'' +
                ", viewCount=" + viewCount +
                ", hotScore=" + hotScore +          // 新增字段
                ", lastCalculated=" + lastCalculated + // 新增字段
                '}';
    }
}