package com.example.g8backend.mapper;

import com.example.g8backend.entity.Comment;
import org.apache.ibatis.annotations.*;

import java.util.List;

@Mapper
public interface CommentMapper {

    // 插入评论
    @Insert("INSERT INTO comments (post_id, user_id, content, parent_comment_id) VALUES (#{postId}, #{userId}, #{content}, #{parentCommentId})")
    int insert(Comment comment);

    // 获取顶级评论
    @Select("SELECT * FROM comments WHERE post_id = #{postId} AND parent_comment_id IS NULL ORDER BY created_at DESC")
    List<Comment> findTopLevelCommentsByPostId(Long postId);

    // 获取某个父评论ID对应的子评论
    @Select("SELECT * FROM comments WHERE parent_comment_id = #{parentCommentId} ORDER BY created_at DESC")
    List<Comment> findRepliesByParentCommentId(Long parentCommentId);

    // 删除评论
    @Delete("DELETE FROM comments WHERE comment_id = #{commentId}")
    int deleteById(Long commentId);

    @Select("SELECT COUNT(*) FROM comments WHERE post_id = #{postId}")
    Long selectCountByPostId(@Param("postId") Long postId);
}
