package com.example.g8backend.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.example.g8backend.entity.PostRating;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

public interface PostRatingMapper extends BaseMapper<PostRating> {
    // 自定义查询平均分
    @Select("SELECT AVG(rating) FROM post_ratings WHERE post_id = #{postId}")
    Double calculateAverageRating(@Param("postId") Long postId);

    @Select("SELECT COUNT(*) FROM post_ratings WHERE post_id = #{postId}")
    Integer getRatingCount(@Param("postId") Long postId);

    @Select("SELECT COUNT(DISTINCT user_id) FROM post_ratings WHERE post_id = #{postId}")
    Long selectRatingUserCount(@Param("postId") Long postId);
}