package com.example.g8backend.service.impl;

import com.example.g8backend.entity.User;
import com.example.g8backend.mapper.UserMapper;
import com.example.g8backend.service.AdminService;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@RequiredArgsConstructor
public class AdminServiceImpl implements AdminService {
    private final UserMapper userMapper;

    @Override
    @Transactional
    public boolean grantVip(Long targetUserId) {
        User user = userMapper.selectById(targetUserId);
        if (user == null) {
            return false; // 用户不存在
        }
        user.setUserLevel("vip");
        userMapper.updateById(user);
        return true;
    }
}