package com.example.g8backend.service;

import com.example.g8backend.entity.User;
import com.example.g8backend.mapper.UserMapper;
import com.example.g8backend.service.impl.AdminServiceImpl;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;
import static org.junit.jupiter.api.Assertions.*;
import static org.mockito.Mockito.*;

@ExtendWith(MockitoExtension.class)
public class AdminServiceImplTest {
    @Mock
    private UserMapper userMapper;
    @InjectMocks
    private AdminServiceImpl adminService;

    @Test
    public void testGrantVip_Success() {
        User user = new User();
        user.setUserId(1L);
        when(userMapper.selectById(1L)).thenReturn(user);

        boolean result = adminService.grantVip(1L);
        assertTrue(result);
        assertEquals("vip", user.getUserLevel());
    }

    @Test
    public void testGrantVip_UserNotFound() {
        when(userMapper.selectById(1L)).thenReturn(null);
        boolean result = adminService.grantVip(1L);
        assertFalse(result);
    }
}