package com.example.g8backend.service;

import com.example.g8backend.entity.User;
import com.example.g8backend.mapper.UserMapper;
import com.example.g8backend.service.impl.UserSecurityServiceImpl;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.security.crypto.password.PasswordEncoder;

import static org.junit.jupiter.api.Assertions.*;
import static org.mockito.Mockito.*;

public class UserSecurityServiceImplTest {

    @Mock
    private UserMapper userMapper;
    @Mock
    private PasswordEncoder passwordEncoder;

    @InjectMocks
    private UserSecurityServiceImpl userSecurityService;

    private User user;

    @BeforeEach
    void setUp() {
        MockitoAnnotations.openMocks(this);
        user = new User();
        user.setUserId(1L);
        user.setPassword("encodedOld");
    }

    @Test
    void changePassword_Success() {
        when(userMapper.selectById(1L)).thenReturn(user);
        when(passwordEncoder.matches("old", "encodedOld")).thenReturn(true);
        when(passwordEncoder.encode("new")).thenReturn("encodedNew");
        when(userMapper.updateById(any(User.class))).thenReturn(1);

        boolean result = userSecurityService.changePassword(1L, "old", "new");
        assertTrue(result);
        verify(userMapper).updateById(any(User.class));
    }

    @Test
    void changePassword_WrongOldPassword() {
        when(userMapper.selectById(1L)).thenReturn(user);
        when(passwordEncoder.matches("wrong", "encodedOld")).thenReturn(false);

        assertThrows(RuntimeException.class, () -> userSecurityService.changePassword(1L, "wrong", "new"));
    }
}