package com.example.g8backend.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.example.g8backend.dto.PostHistoryDTO;
import com.example.g8backend.entity.Post;
import com.baomidou.mybatisplus.extension.service.IService;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

public interface IPostService extends IService<Post> {
    List<Post> getPostsByUserId(Long userId);
    void createPost(Post post);
    void createPost(Post post, Long[] tagIds);
    Post updatePost(Post post);
    List<Post> getPostsByType(String postType);
    Long getPostLikeCount(Long postId);
    void likePost(Long userId, Long postId);
    void unlikePost(Long userId, Long postId);

    List<Post> searchPosts(String keyword, List<Long> tagIds, String author); // 更新为支持多个标签

    @Transactional
    void recordViewHistory(Long userId, Long postId);

    @Scheduled(cron = "0 */10 * * * *") // 每10分钟执行一次
    @Transactional
    void calculateHotScores();

    Page<Post> getRecommendedPosts(int page, int size, Long userId);

    Page<Post> getRecommendedByTags(int page, int size, Long userId);

    List<PostHistoryDTO> getViewHistoryWithTitles(Long userId);
}
