package com.example.g8backend.util;

import com.dampcake.bencode.Bencode;
import com.dampcake.bencode.Type;

import java.io.*;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Map;

public class TorrentUtil {

    private static final Bencode bencode = new Bencode(StandardCharsets.ISO_8859_1);

    public static byte[] injectTracker(File torrentFile, String trackerUrl) throws IOException {
        byte[] fileBytes = readBytes(torrentFile);

        Map<String, Object> torrentMap = bencode.decode(fileBytes, Type.DICTIONARY);

        // trackerUrl: ip:port + /announce / {passkey}
        byte[] ISO_trackerUrlByte = trackerUrl.getBytes(StandardCharsets.ISO_8859_1);
        String ISO_trackerUrl = new String(ISO_trackerUrlByte, StandardCharsets.ISO_8859_1);
        torrentMap.put("announce", ISO_trackerUrl); // ISO-8859-1

        return bencode.encode(torrentMap);
    }

    public static String getInfoHash(File torrentFile) throws IOException, IllegalArgumentException {
        byte[] fileBytes = readBytes(torrentFile);
        Map<String, Object> torrentMap = bencode.decode(fileBytes, Type.DICTIONARY);

        if (!torrentMap.containsKey("info")) {
            throw new IllegalArgumentException("Invalid torrent file: missing 'info' dictionary.");
        }

        @SuppressWarnings("unchecked")
        Map<String, Object> info = (Map<String, Object>) torrentMap.get("info");

        // 对 info 字典重新编码
        byte[] infoBytes = bencode.encode(info);

        // 计算 SHA-1 hash
        MessageDigest sha1;
        try {
            sha1 = MessageDigest.getInstance("SHA-1");
        } catch (Exception e) {
            throw new RuntimeException("SHA-1 not supported", e);
        }

        byte[] hash = sha1.digest(infoBytes);
        return bytesToHex(hash);
    }

    public static void saveToFile(byte[] data, File outputFile) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(outputFile)) {
            fos.write(data);
        }
    }

    public static byte[] readBytes(File file) throws IOException {
        try (InputStream in = new FileInputStream(file)) {
            return in.readAllBytes();
        }
    }

    public static String bytesToHex(byte[] hash) {
        StringBuilder hex = new StringBuilder();
        for (byte b : hash) {
            hex.append(String.format("%02x", b));
        }
        return hex.toString();
    }
}
