package com.example.g8backend.service;

import com.example.g8backend.entity.User;
import com.example.g8backend.mapper.UserMapper;
import com.example.g8backend.service.impl.ForgotPasswordServiceImpl;
import com.example.g8backend.util.mailUtil; // Import mailUtil
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.security.crypto.password.PasswordEncoder;

import static org.junit.jupiter.api.Assertions.*;
import static org.mockito.Mockito.*;

public class ForgotPasswordServiceImplTest {

    @Mock
    private UserMapper userMapper;
    @Mock
    private RedisTemplate<String, String> redisTemplate;
    @Mock
    private PasswordEncoder passwordEncoder;
    @Mock
    private mailUtil mailUtil;  // Mock mailUtil

    @InjectMocks
    private ForgotPasswordServiceImpl forgotPasswordService;

    @Mock
    private ValueOperations<String, String> valueOperations; // Mock Redis ValueOperations

    @BeforeEach
    void setUp() {
        MockitoAnnotations.openMocks(this);
        when(redisTemplate.opsForValue()).thenReturn(valueOperations); // Mock Redis operations
    }

    @Test
    void sendCodeToEmail_Success() {
        User user = new User();
        user.setUserName("test");
        user.setEmail("test@example.com");
        when(userMapper.getUserByName("test")).thenReturn(user);

        // Call the method under test
        forgotPasswordService.sendCodeToEmail("test");

        // Verify that mailUtil.sendMail was called once with the expected arguments
        verify(mailUtil, times(1)).sendMail(eq("test@example.com"), eq("重置密码验证码"), contains("您的验证码"));
        verify(redisTemplate, times(1)).opsForValue();
    }

    @Test
    void resetPassword_Success() {
        User user = new User();
        user.setUserName("test");
        user.setPassword("old");
        when(userMapper.getUserByName("test")).thenReturn(user);
        when(redisTemplate.opsForValue().get("reset_code:test")).thenReturn("123456");
        when(passwordEncoder.encode("newpass")).thenReturn("encodedNew");
        when(userMapper.updateById(any(User.class))).thenReturn(1);

        boolean result = forgotPasswordService.resetPassword("test", "123456", "newpass");
        assertTrue(result);
        verify(redisTemplate, times(1)).delete("reset_code:test");
    }

    @Test
    void resetPassword_WrongCode() {
        when(redisTemplate.opsForValue().get("reset_code:test")).thenReturn("654321");
        assertThrows(RuntimeException.class, () -> forgotPasswordService.resetPassword("test", "123456", "newpass"));
    }
}
