package com.example.g8backend.service;

import com.example.g8backend.entity.User;
import com.example.g8backend.entity.UserSignin;
import com.example.g8backend.mapper.UserMapper;
import com.example.g8backend.mapper.UserSigninMapper;
import com.example.g8backend.service.impl.SigninServiceImpl;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;
import java.time.LocalDate;
import static org.junit.jupiter.api.Assertions.*;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.Mockito.*;

@ExtendWith(MockitoExtension.class)
public class SigninServiceImplTest {
    @Mock
    private UserMapper userMapper;
    @Mock
    private UserSigninMapper userSigninMapper;
    @InjectMocks
    private SigninServiceImpl signinService;

    @Test
    public void testSignIn_Success() {
        // 模拟用户初始状态
        User user = new User();
        user.setUserId(1L);
        user.setSigninCount(0);
        user.setUserLevel("lv1");

        when(userSigninMapper.existsByUserIdAndDate(eq(1L), any())).thenReturn(false);
        when(userMapper.selectById(1L)).thenReturn(user);

        boolean result = signinService.signIn(1L);
        assertTrue(result);
        assertEquals(1, user.getSigninCount());
    }

    @Test
    public void testSignIn_AlreadySigned() {
        when(userSigninMapper.existsByUserIdAndDate(eq(1L), any())).thenReturn(true);
        boolean result = signinService.signIn(1L);
        assertFalse(result);
    }

    @Test
    public void testSignIn_UpgradeToLv2() {
        User user = new User();
        user.setUserId(1L);
        user.setSigninCount(2); // 初始签到2次
        user.setUserLevel("lv1");

        when(userSigninMapper.existsByUserIdAndDate(eq(1L), any())).thenReturn(false);
        when(userMapper.selectById(1L)).thenReturn(user);

        boolean result = signinService.signIn(1L);
        assertTrue(result);
        assertEquals(3, user.getSigninCount());
        assertEquals("lv2", user.getUserLevel());
    }

    @Test
    public void testSignIn_UpgradeToLv3() {
        User user = new User();
        user.setUserId(1L);
        user.setSigninCount(9); // 初始签到9次
        user.setUserLevel("lv2");

        when(userSigninMapper.existsByUserIdAndDate(eq(1L), any())).thenReturn(false);
        when(userMapper.selectById(1L)).thenReturn(user);

        boolean result = signinService.signIn(1L);
        assertTrue(result);
        assertEquals(10, user.getSigninCount());
        assertEquals("lv3", user.getUserLevel());
    }
}