package com.example.g8backend.service;

import com.example.g8backend.entity.Post;
import com.example.g8backend.entity.PostTag;
import com.example.g8backend.entity.Tag;
import com.example.g8backend.mapper.PostTagMapper;
import com.example.g8backend.service.impl.PostTagServiceImpl;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

import java.util.List;

import static org.junit.jupiter.api.Assertions.*;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.Mockito.*;

@ExtendWith(MockitoExtension.class)
public class PostTagServiceTest {

    @InjectMocks
    private PostTagServiceImpl postTagService;

    @Mock
    private PostTagMapper postTagMapper;

    private PostTag samplePostTag;

    @BeforeEach
    public void setUp() {
        samplePostTag = new PostTag(1L, 2L);
    }

    @Test
    public void testSave() {
        when(postTagMapper.insert(any(PostTag.class))).thenReturn(1);

        boolean result = postTagService.save(samplePostTag);

        assertTrue(result);
        verify(postTagMapper, times(1)).insert(samplePostTag);
    }

    @Test
    public void testGetPostsByTagIds() {
        Long[] tagIds = {1L, 2L};
        List<Post> expectedPosts = List.of(new Post());
        when(postTagMapper.getPostsByTagIds(tagIds)).thenReturn(expectedPosts);

        List<Post> result = postTagService.getPostsByTagIds(tagIds);

        assertEquals(expectedPosts, result);
        verify(postTagMapper, times(1)).getPostsByTagIds(tagIds);
    }

    @Test
    public void testGetPostsByTagIds_EmptyInput() {
        List<Post> result = postTagService.getPostsByTagIds(new Long[]{});

        assertTrue(result.isEmpty());
        verify(postTagMapper, never()).getPostsByTagIds(any());
    }

    @Test
    public void testGetTagsByPostId() {
        Long postId = 1L;
        List<Tag> expectedTags = List.of(new Tag());
        when(postTagMapper.getTagsByPostId(postId)).thenReturn(expectedTags);

        List<Tag> result = postTagService.getTagsByPostId(postId);

        assertEquals(expectedTags, result);
        verify(postTagMapper, times(1)).getTagsByPostId(postId);
    }

    @Test
    public void testGetTagsByPostId_Null() {
        List<Tag> result = postTagService.getTagsByPostId(null);

        assertTrue(result.isEmpty());
        verify(postTagMapper, never()).getTagsByPostId(any());
    }

    @Test
    public void testRemoveByIds() {
        when(postTagMapper.deleteByIds(1L, 2L)).thenReturn(1);

        boolean result = postTagService.removeByIds(samplePostTag);

        assertTrue(result);
        verify(postTagMapper, times(1)).deleteByIds(1L, 2L);
    }
}
