package com.example.g8backend.util;

import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;

import static org.assertj.core.api.Assertions.assertThat;
import static org.mockito.Mockito.verify;

@ExtendWith(MockitoExtension.class)
class MailUtilTest {

    @Mock
    private JavaMailSender javaMailSender;

    @InjectMocks
    private mailUtil mailUtil; // 注意类名应与原类一致（原类名可能应改为大写，此处保持原样）

    @Test
    void sendMail_ShouldSendEmailWithCorrectParameters() {
        // 准备测试数据
        String to = "xxi13552467509@163.com";
        String subject = "Test Subject";
        String messageText = "Hello, this is a test email.";

        // 调用被测试方法
        mailUtil.sendMail(to, subject, messageText);

        // 捕获传递给send方法的参数
        ArgumentCaptor<SimpleMailMessage> argumentCaptor = ArgumentCaptor.forClass(SimpleMailMessage.class);
        verify(javaMailSender).send(argumentCaptor.capture());

        // 获取捕获的邮件对象
        SimpleMailMessage sentMail = argumentCaptor.getValue();

        // 验证邮件内容是否正确
        assertThat(sentMail.getFrom()).isEqualTo("2038234690@qq.com");
        assertThat(sentMail.getTo()).containsExactly(to);
        assertThat(sentMail.getSubject()).isEqualTo(subject);
        assertThat(sentMail.getText()).isEqualTo(messageText);
    }
}