package com.example.g8backend.controller;

import com.example.g8backend.entity.User;
import com.example.g8backend.entity.Torrent;
import com.example.g8backend.service.IUserService;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.*;
import com.example.g8backend.service.ITorrentService;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

@RestController
@RequestMapping("/torrent")
public class TorrentController {
    @Autowired
    private ITorrentService torrentService;

    @Autowired
    private IUserService userService;

    @RequestMapping("/upload")
    public ResponseEntity<?> handleTorrentUpload(@RequestParam("file") MultipartFile multipartFile) throws IOException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        long userId = (long) authentication.getPrincipal();

        User user = userService.getById(userId);
        String passkey = user.getPasskey();

        File tempFile = File.createTempFile("upload-", ".torrent");
        multipartFile.transferTo(tempFile);

        try {
            torrentService.handleTorrentUpload(tempFile, userId, passkey);
        } catch (IllegalArgumentException e) {
            return ResponseEntity.badRequest().body(e.getMessage());
        }

        // 删除临时文件
        if(!tempFile.delete()){
            throw new IOException("Failed to delete temporary file: " + tempFile.getAbsolutePath());
        }
        return ResponseEntity.ok("种子上传成功");
    }

    @GetMapping("/download/{torrentId}")
    public void downloadTorrent(@PathVariable String torrentId, HttpServletResponse response) throws IOException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        long userId = (long) authentication.getPrincipal();

        User user = userService.getById(userId);
        String passkey = user.getPasskey();
        Torrent torrent = torrentService.findByTorrentId(Long.parseLong(torrentId));
        File tempFile = torrentService.handleTorrentDownload(torrent, passkey);

        response.setContentType("application/x-bittorrent");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + torrent.getTorrentName() + "\"");

        try (InputStream inputStream = new FileInputStream(tempFile)) {
            inputStream.transferTo(response.getOutputStream());
        }
        if (!tempFile.delete()) {
            throw new IOException("Failed to delete temporary file: " + tempFile.getAbsolutePath());
        }
    }
}
