package com.example.g8backend.service.impl;

import com.example.g8backend.entity.Post;
import com.example.g8backend.entity.User;
import com.example.g8backend.mapper.UserMapper;
import com.example.g8backend.mapper.PostMapper;
import com.example.g8backend.service.AdminService;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;

@Service
@RequiredArgsConstructor
public class AdminServiceImpl implements AdminService {
    private final UserMapper userMapper;

    @Override
    @Transactional
    public boolean grantVip(Long targetUserId) {
        User user = userMapper.selectById(targetUserId);
        if (user == null) {
            return false; // 用户不存在
        }
        user.setUserLevel("vip");
        userMapper.updateById(user);
        return true;
    }

    private final PostMapper postMapper;

    @Override
    @Transactional
    public boolean banUser(Long userId, String reason, Long adminId) {
        User user = userMapper.selectById(userId);
        if (user == null) return false;

        user.setIsBanned(true);
        user.setBannedReason(reason);
        user.setBannedAt(LocalDateTime.now());
        user.setBannedBy(adminId);

        return userMapper.updateById(user) > 0;
    }

    @Override
    @Transactional
    public boolean unbanUser(Long userId, Long adminId) {
        User user = userMapper.selectById(userId);
        if (user == null) return false;

        user.setIsBanned(false);
        user.setBannedReason(null);
        user.setBannedAt(null);
        user.setBannedBy(null);

        return userMapper.updateById(user) > 0;
    }

    @Override
    @Transactional
    public boolean lockPost(Long postId, String reason, Long adminId) {
        Post post = postMapper.selectById(postId);
        if (post == null) return false;

        post.setIsLocked(true);
        post.setLockedReason(reason);
        post.setLockedAt(LocalDateTime.now());
        post.setLockedBy(adminId);

        return postMapper.updateById(post) > 0;
    }

    @Override
    @Transactional
    public boolean unlockPost(Long postId, Long adminId) {
        Post post = postMapper.selectById(postId);
        if (post == null) return false;

        post.setIsLocked(false);
        post.setLockedReason(null);
        post.setLockedAt(null);
        post.setLockedBy(null);

        return postMapper.updateById(post) > 0;
    }
}