package com.example.g8backend.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.example.g8backend.entity.UserStats;
import com.example.g8backend.mapper.UserStatsMapper;
import com.example.g8backend.service.IUserStatsService;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

@Service
public class UserStatsServiceImpl extends ServiceImpl<UserStatsMapper, UserStats> implements IUserStatsService {
    @Override
    public void increaseDownloadedBytes(Long userId, double downloadedBytes) {
        UserStats userStats = this.getById(userId);
        if (userStats != null) {
            userStats.setTotal_download(userStats.getTotal_download() + downloadedBytes);
            userStats.setLast_update_time(LocalDateTime.now());
            this.updateById(userStats);
        } else {
            // 如果记录不存在，可选：创建新记录（视项目逻辑而定）
            UserStats newStats = new UserStats();
            newStats.setUserId(userId);
            newStats.setTotal_download(downloadedBytes);
            newStats.setTotal_upload(0.0);
            newStats.setLast_update_time(LocalDateTime.now());
            this.save(newStats);
        }
    }


}
