package com.example.g8backend.controller;

import com.example.g8backend.entity.User;
import com.example.g8backend.service.IUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.example.g8backend.service.ITorrentService;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.IOException;

@RestController
@RequestMapping("/torrent")
public class TorrentController {
    @Autowired
    private ITorrentService torrentService;

    @Autowired
    private IUserService userService;

    @RequestMapping("/upload")
    public ResponseEntity<?> handleTorrentUpload(@RequestParam("file") MultipartFile multipartFile) throws IOException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        long userId = (long) authentication.getPrincipal();

        User user = userService.getById(userId);
        String passkey = user.getPasskey();

        File tempFile = File.createTempFile("upload-", ".torrent");
        multipartFile.transferTo(tempFile);

        torrentService.handleTorrentUpload(tempFile, userId, passkey);

        // 删除临时文件
        if(!tempFile.delete()){
            throw new IOException("Failed to delete temporary file: " + tempFile.getAbsolutePath());
        }
        return ResponseEntity.ok("种子上传成功");
    }
}
