package com.example.g8backend.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import com.example.g8backend.service.ITrackerService;

@RestController
@RequestMapping("/tracker")
public class TrackerController {

    @Autowired
    private ITrackerService trackerService;

    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    @GetMapping("/announce/{passkey}}")
    public ResponseEntity<?> getAnnouncements(
            @RequestParam(name = "info_hash") String infoHash,
            @RequestParam(name = "peer_id") String peerId,
            @RequestParam(name = "port") int port,
            @RequestParam(name = "uploaded") long uploaded,
            @RequestParam(name = "downloaded") long downloaded,
            @RequestParam(name = "left") long left,
            @RequestParam(name = "compact", required = false) int compact,
            @RequestParam(name = "event", required = false) String event,
            @PathVariable String passkey) {

        return null;
    }
}
