package com.example.g8backend.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.example.g8backend.entity.User;
import com.example.g8backend.mapper.UserMapper;
import com.example.g8backend.service.IUserService;
import jakarta.annotation.Resource;
import org.springframework.stereotype.Service;


@Service
public class UserServiceImpl extends ServiceImpl<UserMapper, User> implements IUserService {
    @Resource
    private UserMapper userMapper; // 手动注入 UserMapper

    @Override
    public User getUserByName(String name) { return userMapper.getUserByName(name);} // 调用 UserMapper 的自定义 SQL

    @Override
    public User getUserByEmail(String email) { return userMapper.getUserByEmail(email);}

    @Override
    public User getUserByPasskey(String passkey) { return userMapper.getUserByPasskey(passkey);}

    @Override
    public void registerUser(User user) {userMapper.insert(user);}
}
