package com.example.g8backend.controller;

import com.example.g8backend.dto.ApiResponse;
import com.example.g8backend.entity.User;
import com.example.g8backend.entity.Torrent;
import com.example.g8backend.service.IUserService;
import com.example.g8backend.service.ITorrentService;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

@RestController
@RequestMapping("/torrent")
public class TorrentController {

    @Autowired
    private ITorrentService torrentService;

    @Autowired
    private IUserService userService;

    // 处理种子文件上传
    @PostMapping("/upload")
    public ApiResponse<String> handleTorrentUpload(@RequestParam("file") MultipartFile multipartFile) throws IOException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        long userId = (long) authentication.getPrincipal();

        User user = userService.getById(userId);
        String passkey = user.getPasskey();

        String fileName = multipartFile.getOriginalFilename();

        try {
            assert fileName != null;
        } catch (AssertionError e) {
            return ApiResponse.error(400, "文件名不能为空");
        }

        if (!fileName.endsWith(".torrent")) {
            return ApiResponse.error(400, "文件格式不正确，请上传.torrent格式的文件");
        }

        File tempFile = File.createTempFile("upload-", ".torrent");
        multipartFile.transferTo(tempFile);

        try {
            torrentService.handleTorrentUpload(tempFile, fileName, userId, passkey);
        } catch (IllegalArgumentException e) {
            return ApiResponse.error(400, e.getMessage());
        }

        // 删除临时文件
        if (!tempFile.delete()) {
            throw new IOException("Failed to delete temporary file: " + tempFile.getAbsolutePath());
        }
        return ApiResponse.success("种子上传成功");
    }

    // 下载种子文件
    @GetMapping("/download/{torrentId}")
    public void downloadTorrent(@PathVariable String torrentId, HttpServletResponse response) throws IOException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        long userId = (long) authentication.getPrincipal();

        User user = userService.getById(userId);
        String passkey = user.getPasskey();
        Torrent torrent = torrentService.findByTorrentId(Long.parseLong(torrentId));
        File tempFile = torrentService.handleTorrentDownload(torrent, passkey);

        response.setContentType("application/x-bittorrent");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + torrent.getTorrentName() + "\"");

        try (InputStream inputStream = new FileInputStream(tempFile)) {
            inputStream.transferTo(response.getOutputStream());
        }
        if (!tempFile.delete()) {
            throw new IOException("Failed to delete temporary file: " + tempFile.getAbsolutePath());
        }
    }
}
