package com.example.g8backend.controller;

import com.example.g8backend.dto.ApiResponse;
import com.example.g8backend.entity.Message;
import com.example.g8backend.entity.User;
import com.example.g8backend.service.IUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/user")
public class UserController {

    @Autowired
    private IUserService userService;

    // 获取已登录的用户信息
    @GetMapping
    public ApiResponse<User> getUserInfo(){
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        long userId = (long) authentication.getPrincipal();
        User user = userService.getById(userId);
        user.setPassword(null);  // 不返回密码
        return ApiResponse.success(user);
    }

    // ==================== 关注功能 ====================

    @PostMapping("/follow/{userId}")
    public ApiResponse<Map<String, Boolean>> followUser(@PathVariable Long userId) {
        Long currentUserId = getCurrentUserId();
        boolean success = userService.followUser(currentUserId, userId);
        return ApiResponse.success(Map.of("success", success));
    }

    @DeleteMapping("/follow/{userId}")
    public ApiResponse<Map<String, Boolean>> unfollowUser(@PathVariable Long userId) {
        Long currentUserId = getCurrentUserId();
        boolean success = userService.unfollowUser(currentUserId, userId);
        return ApiResponse.success(Map.of("success", success));
    }

    @GetMapping("/followings")
    public ApiResponse<List<User>> getFollowings() {
        Long currentUserId = getCurrentUserId();
        List<User> followings = userService.getFollowings(currentUserId);
        return ApiResponse.success(followings);
    }

    @GetMapping("/followers")
    public ApiResponse<List<User>> getFollowers() {
        Long currentUserId = getCurrentUserId();
        List<User> followers = userService.getFollowers(currentUserId);
        return ApiResponse.success(followers);
    }

    // ==================== 私信功能 ====================

    @PostMapping("/message/{receiverId}")
    public ApiResponse<Map<String, Long>> sendMessage(
            @PathVariable Long receiverId,
            @RequestBody String content
    ) {
        Long senderId = getCurrentUserId();
        Long messageId = userService.sendMessage(senderId, receiverId, content);
        return ApiResponse.success(Map.of("messageId", messageId));
    }

    @GetMapping("/messages/{otherUserId}")
    public ApiResponse<List<Message>> getMessages(@PathVariable Long otherUserId) {
        Long currentUserId = getCurrentUserId();
        List<Message> messages = userService.getMessages(currentUserId, otherUserId);
        return ApiResponse.success(messages);
    }

    @GetMapping("/messages/history")
    public ApiResponse<List<Message>> getMessageHistory() {
        Long currentUserId = getCurrentUserId();
        List<Message> messages = userService.getMessageHistory(currentUserId);
        return ApiResponse.success(messages);
    }

    // ==================== 工具方法 ====================
    private Long getCurrentUserId() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return (Long) authentication.getPrincipal();
    }
}
