package com.example.g8backend.mapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.example.g8backend.entity.Post;
import com.example.g8backend.entity.PostLike;
import org.apache.ibatis.annotations.*;
import java.util.List;
@Mapper
public interface PostMapper extends BaseMapper<Post> {
    // 获取用户的帖子
    List<Post> getPostsByUserId(@Param("userId") Long userId);
    // 搜索帖子
    @Select("<script>" +
            "SELECT p.* " +
            "FROM posts p " +
            "LEFT JOIN post_tag pt ON p.post_id = pt.post_id " +
            "LEFT JOIN tags t ON pt.tag_id = t.tag_id " +
            "LEFT JOIN users u ON p.user_id = u.user_id " +
            "WHERE (p.post_title LIKE CONCAT('%', #{keyword}, '%') OR p.post_content LIKE CONCAT('%', #{keyword}, '%')) " +
            "<if test='tagIds != null and tagIds.size() > 0'> " +
            "AND pt.tag_id IN " +
            "<foreach item='tagId' collection='tagIds' open='(' separator=',' close=')'> " +
            "#{tagId} " +
            "</foreach> " +
            "</if>" +
            "<if test='author != null'> " +
            "AND u.user_name = #{author} " +
            "</if>" +
            "</script>")
    List<Post> searchPosts(@Param("keyword") String keyword,
                           @Param("tagIds") List<Long> tagIds,
                           @Param("author") String author);
    //  检查用户是否已经点赞该帖子
    @Select("SELECT EXISTS (SELECT 1 FROM post_likes WHERE user_id = #{userId} AND post_id = #{postId})")
    boolean existsByUserIdAndPostId(@Param("userId") Long userId, @Param("postId") Long postId);
    // 插入一条点赞记录
    @Insert("INSERT INTO post_likes (user_id, post_id) VALUES (#{userId}, #{postId})")
    void insert(PostLike postLike);
    // 删除用户对帖子的点赞记录
    @Delete("DELETE FROM post_likes WHERE user_id = #{userId} AND post_id = #{postId}")
    void deleteLikeByUserIdAndPostId(@Param("userId") Long userId, @Param("postId") Long postId);
    // 获取某个帖子点赞数
    @Select("SELECT COUNT(*) FROM post_likes WHERE post_id = #{postId}")
    Long selectCount(@Param("postId") Long postId);
    @Update("UPDATE posts SET view_count = view_count + 1 WHERE post_id = #{postId}")
    void incrementViewCount(Long postId);
    @Select("SELECT COUNT(*) FROM post_likes WHERE post_id = #{postId}")
    Long selectLikeCount(Long postId);
    @Select("SELECT post_id FROM post_views WHERE user_id = #{userId}")
    List<Long> findViewedPostIds(Long userId);
    @Update({
            "<script>",
            "UPDATE posts",
            "SET hot_score = CASE",
            "  <foreach collection='posts' item='post'>",
            "    WHEN post_id = #{post.postId} THEN #{post.hotScore}",
            "  </foreach>",
            "END,",
            "last_calculated = NOW()",
            "WHERE post_id IN",
            "  <foreach collection='posts' item='post' open='(' separator=',' close=')'>",
            "    #{post.postId}",
            "  </foreach>",
            "</script>"
    })
    int batchUpdateHotScore(@Param("posts") List<Post> posts);
}