package com.example.g8backend.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.example.g8backend.entity.Message;
import com.example.g8backend.entity.User;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface IUserService extends IService<User> {
    User getUserByName(@Param("name") String name);
    User getUserByEmail(@Param("email") String email);
    User getUserByPasskey(@Param("passkey") String passkey);

    // 关注功能
    boolean followUser(Long followerId, Long followedId);
    boolean unfollowUser(Long followerId, Long followedId);
    List<User> getFollowings(Long userId);
    List<User> getFollowers(Long userId);

    // 私信功能
    Long sendMessage(Long senderId, Long receiverId, String content);
    List<Message> getMessages(Long userId, Long partnerId);
    List<Message> getMessageHistory(Long userId);
}
