package com.example.g8backend.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.example.g8backend.entity.Message;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

@Mapper
public interface MessageMapper extends BaseMapper<Message> {
    @Select("SELECT * FROM private_messages " +
            "WHERE (sender_id=#{userId1} AND receiver_id=#{userId2}) " +
            "OR (sender_id=#{userId2} AND receiver_id=#{userId1}) " +
            "ORDER BY sent_at")
    List<Message> selectConversation(@Param("userId1") Long userId1, @Param("userId2") Long userId2);

    @Select("SELECT * FROM private_messages " +
            "WHERE sender_id=#{userId} OR receiver_id=#{userId} " +
            "ORDER BY sent_at DESC")
    List<Message> selectUserMessages(Long userId);
}