package com.example.g8backend.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.example.g8backend.entity.Post;
import com.example.g8backend.entity.PostTag;
import com.example.g8backend.entity.Tag;
import com.example.g8backend.mapper.PostTagMapper;
import com.example.g8backend.service.IPostTagService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class PostTagServiceImpl extends ServiceImpl<PostTagMapper, PostTag> implements IPostTagService {

    @Autowired
    private PostTagMapper postTagMapper;

    @Override
    public boolean save(PostTag postTag) {
        return postTagMapper.insert(postTag) > 0;
    }

    @Override
    public List<Post> getPostsByTagIds(Long[] tagIds) {
        if (tagIds == null || tagIds.length == 0) return new ArrayList<>();
        return postTagMapper.getPostsByTagIds(tagIds);
    }

    @Override
    public List<Tag> getTagsByPostId(Long postId) {
        if (postId == null) return new ArrayList<>();
        return postTagMapper.getTagsByPostId(postId);
    }

    @Override
    public boolean removeByIds(PostTag postTag) {
        return postTagMapper.deleteByIds(postTag.getPostId(), postTag.getTagId()) > 0;
    }
}
